
--Rain parameters
kPPS = 10;               -- Number of particles generated per second
kGravity =100;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("butterfly01");
  SetBlendMode(kBlendNormal);
  SetNumParticles(100);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(5500);
TestDone = NewTimeout(10000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-380, 300, 0), Vec3(380,300,0) );
   InitVelocity( "vRange", Vec3(-50, -240, 0), Vec3(50,-150, 0) );
   InitScale( "fRange", .05, .05 );
   InitAge("iRange", 0, 0);
   CreateParticles(newParticles);
  end

   Do("move");
   DoAge("iAge");
 DoColor("cFade",
      Color(1, 1,1, 1), 2500,
      Color(1, 1, 1, 1), 1500,
      Color(1, 1, 1, 0));
   DoScale("fScale",
      .05, 500,
      .3, 500);
   Do("expire", 10000)

end

